
/*= GOODWILL SFG830 Synthesized Function Generator (VISO I/O)================*/
 
/*===========================================================================*/
/*  Please do not use global variables or arrays in the include file of      */
/*  instrument drivers that will be submitted for inclusion into the         */
/*  LabWindows Instrument Driver Library.                                    */
/*===========================================================================*/
     
#ifndef __gwsfg830_HEADER
#define __gwsfg830_HEADER

#include <vpptype.h>

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*****************************************************************************/
/*= Instrument Driver Specific Error/Warning Codes ==========================*/
/*****************************************************************************/
#define VI_ERROR_INSTR_FILE_OPEN                (_VI_ERROR+0x3FFC0800L)
#define VI_ERROR_INSTR_FILE_WRITE               (_VI_ERROR+0x3FFC0801L)
#define VI_ERROR_INSTR_INTERPRETING_RESPONSE    (_VI_ERROR+0x3FFC0803L)
#define VI_ERROR_INSTR_PARAMETER9               (_VI_ERROR+0x3FFC0809L)
#define VI_ERROR_INSTR_PARAMETER10              (_VI_ERROR+0x3FFC080AL)
#define VI_ERROR_INSTR_PARAMETER11              (_VI_ERROR+0x3FFC080BL)
#define VI_ERROR_INSTR_PARAMETER12              (_VI_ERROR+0x3FFC080CL)
#define VI_ERROR_INSTR_PARAMETER13              (_VI_ERROR+0x3FFC080DL)
#define VI_ERROR_INSTR_PARAMETER14              (_VI_ERROR+0x3FFC080EL)
#define VI_ERROR_INSTR_PARAMETER15              (_VI_ERROR+0x3FFC080FL)

/*****************************************************************************/
/*= Define Instrument Specific Error/Warning Codes Here =====================*/
/*****************************************************************************/
#define VI_WARNING_INSTR_OFFSET                           (0x3FFC0900L)
#define VI_ERROR_INSTR_OFFSET                   (_VI_ERROR+0x3FFC0900L)

#define gwsfg830_WARN_LOW_BATTERY          (VI_WARNING_INSTR_OFFSET + 0xF0L)

#define gwsfg830_ERROR_PROGRAMMING_INSTR   (VI_ERROR_INSTR_OFFSET + 0xF2L)
#define gwsfg830_ERROR_AMP_AND_OFF         (VI_ERROR_INSTR_OFFSET + 0xF4L) 

/*****************************************************************************/
/*= GLOBAL USER-CALLABLE FUNCTION DECLARATIONS (Exportable Functions) =======*/
/*****************************************************************************/
ViStatus _VI_FUNC gwsfg830_init (ViRsrc resourceName, ViBoolean IDQuery,
                    ViBoolean resetDevice, ViPSession instrumentHandle);
ViStatus _VI_FUNC gwsfg830_generateWaveform (ViSession instrumentHandle,
                    ViInt16 waveformType, ViReal64 sampleFrequency, 
                    ViReal64 amplitude, ViReal64 DCOffset);
ViStatus _VI_FUNC gwsfg830_configWvfm (ViSession instrumentHandle,
                    ViInt16 waveformType, ViReal64 sampleFrequency, 
                    ViReal64 amplitude, ViReal64 DCOffset);
ViStatus _VI_FUNC gwsfg830_configAMFM (ViSession instrumentHandle,
                    ViInt16 modulationWaveform, ViBoolean modulationType,
                    ViReal64 depthorSpanorHz, ViReal64 sweepRateHz);
ViStatus _VI_FUNC gwsfg830_configPM (ViSession instrumentHandle, ViReal64 phasedeg,
                    ViReal64 sweepRateHz);
ViStatus _VI_FUNC gwsfg830_configLogLin (ViSession instrumentHandle,
                    ViInt16 sweepType, ViInt16 modulationWaveform,
                    ViReal64 startFrequencyHz, ViReal64 stopFrequencyHz,
                    ViReal64 sweepRateHz);
ViStatus _VI_FUNC gwsfg830_setmodulation (ViSession instrumentHandle,
                    ViBoolean setModulationState);
ViStatus _VI_FUNC gwsfg830_dataReadSetting (ViSession instrumentHandle,
                    ViInt16 messageType, ViChar _VI_FAR message[]);
ViStatus _VI_FUNC gwsfg830_writeInstrData (ViSession instrumentHandle,
                    ViString writeBuffer);
ViStatus _VI_FUNC gwsfg830_readInstrData (ViSession instrumentHandle,
                    ViInt32 numberBytesToRead, ViChar _VI_FAR readBuffer[],
                    ViPInt32 numBytesRead);
ViStatus _VI_FUNC gwsfg830_reset (ViSession instrumentHandle);
ViStatus _VI_FUNC gwsfg830_selfTest (ViSession instrumentHandle,
                    ViPInt16 selfTestResult, ViChar _VI_FAR selfTestMessage[]);
ViStatus _VI_FUNC gwsfg830_errorQuery (ViSession instrumentHandle,
                    ViPInt32 errorCode, ViChar _VI_FAR errorMessage[]);
ViStatus _VI_FUNC gwsfg830_errorMessage (ViSession instrumentHandle,
                    ViStatus statusCode, ViChar _VI_FAR message[]);
ViStatus _VI_FUNC gwsfg830_revisionQuery (ViSession instrumentHandle,
                    ViChar _VI_FAR instrumentDriverRevision[],
                    ViChar _VI_FAR firmwareRevision[]);
ViStatus _VI_FUNC gwsfg830_close (ViSession instrumentHandle);

#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif
